function cb_m44  
% Menu 44
% Approximate impedance

  global f
  global sR0                 
  global isR0Variable       
  global sC0           
  global sLs          
  global sRs 
  global sfontsize 
  global persParamsDir   
  global puzFname
  global puDataDir 
  global relmin
  global m44
  global hdt
  
  capt = get(m44,'label');  
  
  options=optimset('fminsearch');
  options=optimset(options,'MaxFunEvals',100000);
  options=optimset(options,'MaxIter',100000);
  options=optimset(options,'TolFun',1e-6);
  options=optimset(options,'TolX',1e-6);
  
  [fname, fpath, fltidx] = uigetfile({'*.puz','Open a PUZ - file'}, ...
                           capt,strcat(puDataDir,puzFname));
  
  if fltidx > 0
   
    cancelMeasurement; 
    
    puzFname=fname;
    puDataDir=fpath;
    sn = strcat(persParamsDir,'puDirFname.mat');
    save(sn,'puDataDir', 'puzFname');  
    
    loadname=strcat(puDataDir,puzFname);
    planename=strrep(puzFname,'.puz','');
    savename=strcat(puDataDir,planename,'.pup');
    titlename=strcat(planename,': (Z, Za) / \Omega');
    printname=strcat(puDataDir,planename,' Za.png');
    
    load(loadname,'-mat');
    
    s=j*2*pi*f;
   
    ncoils=1;
    if sLs(2) > 0
      ncoils = 2;
      if sLs(3) > 0 
        ncoils = 3;
      end
    end
    
    if isR0Variable      
      x00=[sR0, sC0, sLs(1:ncoils), sRs(1:ncoils)];    
      x0=ones(1,2+2*ncoils);
      p=[];      
      [x mse]=fminsearch(@(x) mseapproxZ(x,x00,relmin,p,s,Z), x0, options);
      l=length(x);
      xmin = ones(1,l)*relmin;
      x=max(x,xmin);
      Za =approxZ(x,x00,relmin,p,s);      
      xx=x00.*x;
      R0 = xx(1);
      C0 = xx(2);
      for i=1:3
        if i <=ncoils          
          Ls(i) = xx(2+i);
          Rs(i) = xx(2+ncoils+i);
        else
          Ls(i) = 0;
          Rs(i) = 0;
        end
      end
    else
      x00=[sC0, sLs(1:ncoils), sRs(1:ncoils)];    
      x0=ones(1,1+2*ncoils);
      p=[sR0];      
      [x mse]=fminsearch(@(x) mseapproxZ(x,x00,relmin,p,s,Z), x0, options);
      l=length(x);
      xmin = ones(1,l)*relmin;
      x=max(x,xmin);
      Za =approxZ(x,x00,relmin,p,s);      
      xx=x00.*x;
      R0 = sR0;
      C0 = xx(1);
      for i=1:3
        if i <=ncoils          
          Ls(i) = xx(1+i);
          Rs(i) = xx(1+ncoils+i);
        else
          Ls(i) = 0;
          Rs(i) = 0;
        end
      end      
    end   
    
    rmse=sqrt(mse);   
    save('-mat',savename,'planename','R0', 'C0','Ls','Rs','rmse');
                    
    delname =strcat(puDataDir,planename,' FR.png');
    if exist(delname, 'file') == 2
        delete(delname) 
    end;
   
    L=20*log10(abs(Z));    
    P=180/pi*angle(Z); 
    
    La=20*log10(abs(Za));    
    Pa=180/pi*angle(Za);     
    
    if ishandle(hdt) 
        delete(hdt) 
    end;
    
    fa=f(1);
    fb=f(end);
    
    subplot(2,1,1)
    
    semilogx(f,L,'b',f,La,'r')
    axis([fa fb 55 125])
    grid
    title(titlename);
    xlabel('Frequency / Hz')
    ylabel('Gain / dB')
    ha1=gca;
    
    ht1=text(25,118,['R0 = ',num2str(R0/1e3,4'),' k\Omega']);
    ht2=text(120,118,['C0 = ',num2str(C0/1e-12,4'),' pF']);
    
    ht3=text(25,108,['L1 = ',num2str(Ls(1),4'),' H']);
    ht4=text(120,108,['R1 = ',num2str(Rs(1)/1e3,4),' k\Omega']);
    
    if  Ls(2)~=0
      ht5=text(25,98,['L2 = ',num2str(Ls(2),4'),' H']);
      ht6=text(120,98,['R2 = ',num2str(Rs(2)/1e3,4),' k\Omega']);
    end 
    if  Ls(3)~=0
      ht7=text(25,88,['L3 = ',num2str(Ls(3),4'),' H']);
      ht8=text(120,88,['R3 = ',num2str(Rs(3)/1e3,4),' k\Omega']);
    end
    
    ht9=text(25,62,['RMS Error = ',num2str(rmse,2),' dB']);
    
    subplot(2,1,2) 
    
    semilogx(f,P,'b',f,Pa,'r')
    axis([fa fb -100 100]);
    grid
    xlabel('Frequency / Hz')
    ylabel('Phase / degree')
    ha2=gca;
    
    set(gcf,'PaperUnits','inches','PaperPosition',[0 0 9 6]);  
    print('-dpng', printname,'-r300')
    
    set(ha1, 'fontsize',sfontsize);   
    set(ha2, 'fontsize',sfontsize); 
    set(ht1,'fontsize', sfontsize); 
    set(ht2,'fontsize', sfontsize); 
    set(ht3, 'fontsize', sfontsize); 
    set(ht4,'fontsize', sfontsize); 
    if  Ls(2)~=0
      set(ht5,'fontsize', sfontsize);
      set(ht6,'fontsize', sfontsize);  
    end
    if  Ls(3)~=0
      set(ht7,'fontsize', sfontsize); 
      set(ht8, 'fontsize', sfontsize);
    end    
    set(ht9,'fontsize', sfontsize); 
    
  end
  
end

